/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.domain;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.MessageId;
import com.ibm.hwmca.fw.util.msgsvc.MessageService;
import com.ibm.hwmca.fw.util.msgsvc.MessageSubscriber;
import com.ibm.hwmca.fw.util.msgsvc.PartitionedMessage;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityThread;

public abstract class DistributedDomain
extends Domain
implements MessageSubscriber {
    private static final String TRACE_MASKT = "XFRMDDMT";
    private static final String TRACE_MASKF = "XFRMDDMF";
    private static final String TRACE_MASKD = "XFRMDDMD";

    public DistributedDomain() {
    }

    public DistributedDomain(DomainIdentifier did) {
        super(did);
    }

    public void addParticipant(Object participant) throws HException {
        try {
            RemoteEntity re = (RemoteEntity)participant;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> addParticipant: Participant doesn't implement necessary RemoteEntity interface");
            throw new HException("Participant doesn't implement necessary RemoteEntity interface");
        }
        super.addParticipant(participant);
    }

    protected void initialize() {
        super.initialize();
        MessageService.getMessageService().subscribeToRemote(this.getDomainMessageId(), (MessageSubscriber)this, false);
    }

    public void remove() {
        super.remove();
        MessageService.getMessageService().unsubscribe(this.getDomainMessageId(), (MessageSubscriber)this);
    }

    public MessageId getDomainMessageId() {
        return new MessageId("DD." + this.getDomainId().getDID());
    }

    public boolean isPublicationEnabled() {
        return true;
    }

    protected void queuePublication(RemoteEntity re, PartitionedMessage msg) throws HException {
        if (!this.isPublicationEnabled()) {
            throw new HException("Domain publication disabled");
        }
        RemoteEntityThread.getRemoteEntityThread(re).queuePublication(msg);
    }

    public void broadcastMessage(PartitionedMessage msg) throws HException {
        if (!this.hasParticipants()) {
            Trace.trace(TRACE_MASKD, "<-> broadcastMessage: no participants, message not broadcast");
            return;
        }
        if (!this.isPublicationEnabled()) {
            throw new HException("Domain publication disabled");
        }
        MessageService.getMessageService().publishToRemote(msg, this.getParticipants(), false);
    }

    public void receiveMessage(Message msg, Object sender2) {
        Trace.trace(TRACE_MASKD, "<-> receiveMessage: ");
        Trace.trace(TRACE_MASKD, "    our domain: " + this.getDomainTrace(""));
        Trace.trace(TRACE_MASKD, "    sender: " + ((Object)((RemoteEntity)sender2)).toString());
        PartitionedMessage partMsg = null;
        if (msg instanceof PartitionedMessage) {
            partMsg = (PartitionedMessage)msg;
        }
        if (partMsg == null) {
            Trace.trace(TRACE_MASKT, "Invalid Message (not partitioned).  Message discarded.");
            return;
        }
        Trace.trace(TRACE_MASKD, "    msg partition: " + partMsg.getPartition());
        if (!(sender2 instanceof RemoteEntity)) {
            Trace.trace(TRACE_MASKT, "Invalid Message (sender not RemoteEntity).  Message discarded.");
            return;
        }
        this.handleMessage(partMsg, (RemoteEntity)sender2);
    }

    protected abstract void handleMessage(PartitionedMessage var1, RemoteEntity var2);
}

